<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ShoppingCartStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'product_hash' => 'required',
            'world_name' => 'required',
            'grow_id' => 'required',
            'quantity' => 'integer|min:1',
            'world_name_hash' => 'required',
            'grow_id_hash' => 'required'
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'variants.required' => __('words.variation_required'),
        ];
    }
}
