@extends('panel.layouts.extends')
@section('title')
@lang('words.theme')
@endsection
@section('script')
<script>
    $('#primary, #secondary').spectrum({
        type: "component"
    });
</script>
@endsection
@section('content')
<br> <br> <br>
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <section>
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="pt-1 pb-1">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        @if ($m = Session::get('success'))
                        <div class="alert alert-success" role="alert">
                            <div class="alert-body">
                                {{ $m }}
                            </div>
                        </div>
                        @endif
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">@lang('words.theme')</h4>
                            </div>
                            <form method="POST" action="{{ route('panel.theme.update') }}">
                                @csrf
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="color">@lang('words.primary_color')</label>
                                                <input class="form-control" name="primary" id="primary"  value="{{ setting('primary') }}"/>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="color">@lang('words.secondary_color')</label>
                                                <input class="form-control" name="secondary" id="secondary" value="{{ setting('secondary') }}"/>
                                            </div>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-primary waves-effect waves-float waves-light mt-2 mb-2 float-right">@lang('words.save')</button>
                                </div>
                            </form>
                            <hr>


                            <form action="{{ route('panel.theme.updatetwo') }}" method="post">
                                @csrf

                                <div class="card-body">
                                    <div class="form-group">
                                        <label class="form-label">
                                            Banner Aktif/Pasif
                                        </label>
                                        <select class="form-control" name="banneraktiflik">
                                            <?php  
                                            $data = [
                                                "0"=>"Pasif",
                                                "1"=>"Aktif"
                                            ];
                                            foreach ($data as $key => $value) { ?>
                                                <option value="<?php echo $key; ?>" <?php if(\App\Models\settings::first()->set_banner==$key) {
                                                  echo "selected";
                                              } ?>>
                                              <?php echo $value; ?>
                                          </option>
                                      <?php } ?>
                                  </select>
                              </div>

                              <div class="form-group">
                                <label class="form-label">
                                    Hikaye Aktif/Pasif
                                </label>
                                <select class="form-control" name="hikayeaktiflik">
                                    <?php  
                                    $data = [
                                        "0"=>"Pasif",
                                        "1"=>"Aktif"
                                    ];
                                    foreach ($data as $key => $value) { ?>
                                        <option value="<?php echo $key; ?>" <?php if(\App\Models\settings::first()->set_hikaye==$key) {
                                          echo "selected";
                                      } ?>>
                                      <?php echo $value; ?>
                                  </option>
                              <?php } ?>
                          </select>
                      </div>

                      <div class="form-group">
                        <label class="form-label">
                            Diğer Aktif/Pasif
                        </label>
                        <select class="form-control" name="digeraktiflik">
                            <?php  
                            $data = [
                                "0"=>"Pasif",
                                "1"=>"Aktif"
                            ];
                            foreach ($data as $key => $value) { ?>
                                <option value="<?php echo $key; ?>" <?php if(\App\Models\settings::first()->set_pop==$key) {
                                  echo "selected";
                              } ?>>
                              <?php echo $value; ?>
                          </option>
                      <?php } ?>
                  </select>
              </div>


              <button type="submit" class="btn btn-primary waves-effect waves-float waves-light mt-2 mb-2 float-right">@lang('words.save')</button>                          
          </div>
      </form>

  </div>
</div>
</div>
</section>
</div>
</div>
</div>
@endsection