<?php



function kdvhesapla( $data ) {

	$data  = $data / 100;

	$data  = $data * 18;

	return $data;

}

		

function bizimhesap( $musteriID, $firmId, $invoiceNo, $urunlerID ) {

	

	global $db;

	global $_SESSION;

	

	$d = new DateTime('now');

	$d->setTimezone(new DateTimeZone('UTC'));

	$date = $d->format('Y-m-d');

	$time = $d->format('H:i:s');

	$fullDate = $date . 'T' . $time . '.516+03:00';

	

	$query = $db->prepare("SELECT * FROM siparis WHERE id=:id LIMIT 1");

	$k = $query->execute(array(":id"=>$_GET['no']));

	$k = $query->fetch(PDO::FETCH_ASSOC);

	

	$urunler      = array();

	$genelToplam  = 0;

		

		$urun = $db->query("SELECT * FROM urun WHERE id IN ({$urunlerID})")->fetchAll(PDO::FETCH_ASSOC);

		foreach ( $urun as $data ) {

			$toplam       = $data["fiyat"];

			$urunToplam   = $toplam + kdvhesapla($toplam);

			$genelToplam += $toplam;

			$urunler[] = array(

				"productId"      => $data["id"],

				"productName"    => $data["baslik"],

				"taxRate"        => number_format(8, 2, ".", ","),

				"quantity"       => 1,

				"unitPrice"      => $data["fiyat"],

				"grossPrice"     => number_format($toplam, 2, ".", ","),

				"discount"       => "0.00",

				"net"            => number_format($toplam, 2, ".", ","),

				"tax"            => number_format(kdvhesapla($toplam), 2, ".", ","),

				"total"          => number_format($urunToplam, 2, ".", ",")

			);

		}

		

	$toplamTutar = $genelToplam + kdvhesapla($genelToplam);



	$postData = array(

		"firmId"             => $firmId,

		"invoiceNo"          => $invoiceNo,

		"invoiceType"        => 3,

		"dates" => array(

			"invoiceDate"    => $fullDate,

			"dueDate"        => $fullDate,

			"deliveryDate"   => $fullDate

			),

		"customer" => array(

			"customerId"     => $musteriID,

			"title"          => $k['ad'] . ' ' . $k['soyad'],

			"email"          => $k['email'],

			"phone"          => $k['telefon'],

			"address"        => $k['adres']

			),

		"amounts" => array(

			"currency"       => "TL",

			"gross"          => number_format($genelToplam, 2, ".", ","),

			"discount"       => "0.00",

			"net"            => number_format($genelToplam, 2, ".", ","),

			"tax"            => number_format(kdvhesapla($genelToplam), 2, ".", ","),

			"total"          => number_format($toplamTutar, 2, ".", ",")

			),

		"details"            => $urunler

		);

		

	$data_string = json_encode($postData);

	$options = array(

		CURLOPT_CUSTOMREQUEST  => "POST",

		CURLOPT_POSTFIELDS     => $data_string,

		CURLOPT_RETURNTRANSFER => true,

		CURLOPT_HTTPHEADER     => array(

			'Content-Type: application/json',

			'Content-Length: ' . strlen($data_string)

		),

		CURLOPT_HEADER         => false,

		CURLOPT_FOLLOWLOCATION => true,

		CURLOPT_ENCODING       => "",

		CURLOPT_USERAGENT      => "spider",

		CURLOPT_AUTOREFERER    => true,

		CURLOPT_CONNECTTIMEOUT => 120,

		CURLOPT_TIMEOUT        => 120,

		CURLOPT_MAXREDIRS      => 10,

		CURLOPT_SSL_VERIFYPEER => false

	);

	$ch      = curl_init( 'https://bizimhesap.com/api/b2b/addinvoice' );

	curl_setopt_array( $ch, $options );

	$content = curl_exec( $ch );

	$err     = curl_errno( $ch );

	$errmsg  = curl_error( $ch );

	$header  = curl_getinfo( $ch );

	curl_close( $ch );

	$header['errno']   = $err;

	$header['errmsg']  = $errmsg;

	$header['content'] = $content;

	$result = $header['content'];

	

	$error  = explode('error":"',$result);

	$error  = explode('"',$error[1]);

	$error  = $error[0];

	$url    = explode('url":"',$result);

	$url    = explode('"',$url[1]);

	$url    = $url[0];

	$guid   = explode('guid":"',$result);

	$guid   = explode('"',$guid[1]);

	$guid   = $guid[0];

	

	if ( !empty($error) ) {

		$array = array(

			"hata" => 1,

			"url"  => '',

			"guid" => '',

		);

	} else {

		$array = array(

			"hata" => 0,

			"url"  => $url,

			"guid" => $guid,

		);

	}

	

	return $array;



}



?>