@extends('panel.layouts.extends')
@section('title')
@lang('words.product_create')
@endsection
@include('panel.product.create.script.script')
@section('content')
<br> <br> <br>
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <form action="{{ route('panel.product.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
            <section>
                <div class="row justify-content-center">
                    <div class="col-xl-9 col-lg-12">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="pt-1 pb-1">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if ($m = Session::get('success'))
                            <div class="alert alert-success" role="alert">
                                <div class="alert-body">
                                    {{ $m }}
                                </div>
                            </div>
                        @endif
                        <div class="card">
                            <div class="card-body">
                                <ul class="nav nav-tabs justify-content-center" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="product-tab" data-toggle="tab" href="#product" aria-controls="home" role="tab" aria-selected="false">
                                            <i data-feather='shopping-bag'></i>
                                        @lang('words.product')
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="images-tab" data-toggle="tab" href="#images" aria-controls="about" role="tab" aria-selected="true">
                                            <i data-feather='upload'></i>
                                            @lang('words.images')
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="information-tab" data-toggle="tab" href="#information" aria-controls="about" role="tab" aria-selected="true">
                                            <i data-feather='info'></i>
                                            @lang('words.information')
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="seo-tab" data-toggle="tab" href="#seo" aria-controls="about" role="tab" aria-selected="true">
                                            <i data-feather='airplay'></i>
                                            @lang('words.seo')
                                        </a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="product" aria-labelledby="product-tab" role="tabpanel">
                                        <div class="card">
                                                <div class="card-body">
                                                    <div class="form-group">
                                                        <label for="name">@lang('words.product_name')</label>
                                                        <input type="text" class="form-control" name="title" id="seo_title">
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="category_name">@lang('words.price')</label>
                                                        <input type="text" class="form-control" name="price">
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="category_name">@lang('words.discount_price')</label>
                                                        <div class="badge badge-light-success">@lang('words.product_discount_alert')
                                                        </div>
                                                        <input type="text" class="form-control" name="discount">
                                                    </div>

                                                    <div class="form-group">
                                                        <label>@lang('words.category')</label>
                                                        <select class="select2 form-control" name="category_id">
                                                                @foreach ($categories as $c)
                                                                    <option value="{{ $c->id }}">{{ $c->title }}</option>
                                                                @if (count($c->getAllCategoriesCollection) > 0)
                                                                    @include('panel.product.create.layouts.parents', ['getAllSubCategoriesCollection' => $c->getAllCategoriesCollection, 'parent_title' => $c->title])
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="form-group">
                                                        <label>@lang('words.brand')</label>
                                                        <select class="select2 form-control" name="brand_id">
                                                                @foreach ($brands as $b)
                                                                    <option value="{{ $b->id }}">{{ $b->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="description">@lang('words.description')</label>
                                                        <textarea type="text" class="form-control" name="description" id="tiny"></textarea>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="images" aria-labelledby="images-tab" role="tabpanel">
                                        <div class="card">
                                                <div class="card-body">
                                                    <div class="form-group">
                                                        <label for="name">@lang('words.images')</label>
                                                        <input type="file" class="form-control" name="images[]" multiple>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="information" aria-labelledby="information-tab" role="tabpanel">
                                        <div class="card">
                                            <div class="repeater">
                                                <div class="card-body">
                                                    <div data-repeater-list="informations">
                                                        <div data-repeater-item>
                                                            <div class="row d-flex align-items-end">
                                                                <div class="col-md-5 col-12">
                                                                    <div class="form-group">
                                                                        <label for="name">@lang('words.title')</label>
                                                                        <input type="text" name="information_title" class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-5 col-12">
                                                                    <div class="form-group">
                                                                        <label for="name">@lang('words.description')</label>
                                                                        <input type="text" name="information_description" class="form-control" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-2 col-12">
                                                                    <div class="form-group">
                                                                        <button data-repeater-delete type="button" class="btn btn-danger waves-effect waves-float waves-light w-100">
                                                                            @lang('words.delete')
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <button data-repeater-create type="button" class="btn btn-success waves-effect waves-float waves-light w-100">
                                                        @lang('words.add_attribute')
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="seo" aria-labelledby="seo-tab" role="tabpanel">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <label for="name">@lang('words.seo_description')</label>
                                                    <textarea type="text" class="form-control" name="seo_description" id="seo_description"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label for="name">@lang('words.keywords')</label>
                                                    <textarea type="text" class="form-control" name="keywords" id="keywords"></textarea>
                                                </div>
                                                <div class="form-group bg-white p-5 rounded">
                                                    <label for="name" class="seo-p-color">{{ route('web.index') }}</label>
                                                    <h1 id="title_h" class="text-primary text-decoration-underline">adasdsda</h1>
                                                    <p id="description_p" class="seo-p-color">asdas</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <button type="submit" class="btn btn-warning waves-effect waves-float waves-light w-100">@lang('words.save')</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            </form>
        </div>
    </div>
</div>
@endsection
