<?php

require_once 'Database.php';

class Category
{
    private $id;
    private $database;

    public function __construct()
    {
        $this->database = Database::getInstance();
    }


    /**
     * @param $id integer
     * @return array
     */
    public function get($id = null)
    {
        if (!$id) {
            $id = $this->id;
        }

        return $this->database->query('SELECT * FROM urunk WHERE id=' . $id)->fetchObject();
    }

    /**
     * @return array
     */
    public function getAll()
    {
        $categories = [];

        $categories = $this->database->query('SELECT * FROM urunk')->fetchAll(PDO::FETCH_OBJ);

        if (!empty($categories)) {
            foreach ($categories as $key => $category) {
                $categories[$key]->subCategories = $this->database->query('SELECT * FROM aurunk WHERE ititle='.$category->id)->fetchAll(PDO::FETCH_OBJ);
            }
        }

        return $categories;
    }

    /**
     * @param $param string
     * @return array
     */
    public function searchForSelect2($param)
    {
        return $this->database->query('SELECT id, baslik as text FROM urunk WHERE baslik LIKE "%' . $param . '%"')->fetchAll();
    }

    /**
     * @return array
     */
    public function getSitemapUrls()
    {
        $categories = $this->database->query('SELECT  urunk.seo as ust_kategori_url, aurunk.seo as alt_kategori_url
                                                    FROM urunk 
                                                    LEFT JOIN aurunk ON aurunk.ititle=urunk.id
                                                    WHERE urunk.durum=1')->fetchAll();

        return $categories;
    }

    /**
     * @param $categoryIds string
     * @param $subCategoryIds string
     * @return array
     */
    public function getProductCategories($categoryIds, $subCategoryIds)
    {
        $productCategories = [];
        $categories = $this->database->query('SELECT aurunk.id as category_id,
                                                            aurunk.baslik as  category_title,
                                                            aurunk.resim as category_image,
                                                            CONCAT("altkategoriler", "/", aurunk.seo, ".html") as category_url,
                                                            aurunk.durum as category_status,
                                                            urunk.id as top_category_id,
                                                            urunk.baslik as  top_category_title,
                                                            urunk.resim as top_category_image,
                                                            CONCAT("kategoriler", "/", urunk.seo, ".html") as top_category_url,
                                                            urunk.durum as top_category_status
                                                            FROM aurunk 
                                                            INNER JOIN urunk ON urunk.id = aurunk.ititle AND urunk.id IN (' . $categoryIds . ')
                                                            WHERE aurunk.id IN (' . $subCategoryIds . ')')->fetchAll(PDO::FETCH_OBJ);


        if (!empty($categories)) {
            foreach ($categories as $key => $category) {
                $productCategories[$category->top_category_id]->id = $category->top_category_id;
                $productCategories[$category->top_category_id]->title = $category->top_category_title;
                $productCategories[$category->top_category_id]->url = $category->top_category_url;
                $productCategories[$category->top_category_id]->image = $category->top_category_image;
                $productCategories[$category->top_category_id]->status = $category->top_category_status;
                $productCategories[$category->top_category_id]->subcategories[$category->category_id]->id = $category->category_id;
                $productCategories[$category->top_category_id]->subcategories[$category->category_id]->title = $category->category_title;
                $productCategories[$category->top_category_id]->subcategories[$category->category_id]->url = $category->category_url;
                $productCategories[$category->top_category_id]->subcategories[$category->category_id]->image = $category->category_image;
                $productCategories[$category->top_category_id]->subcategories[$category->category_id]->status = $category->category_status;
            }
        }

        return $productCategories;

    }

    /**
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param integer $id
     * @return Category
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

}