<?php

class Database extends PDO
{
    private static $instance = null;

    const OPTION = array(
        PDO::ATTR_PERSISTENT => FALSE,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'
    );

    public function __construct()
    {
        parent::__construct(
            "mysql:host=" . DB_SERVER . ";dbname=" . DB_DATABASE,
            DB_SERVER_USERNAME,
            DB_SERVER_PASSWORD,
            self::OPTION
        );
    }

    public static function getInstance() {

        if (!self::$instance instanceof self) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    public function __clone() {
        trigger_error('Clone is not allowed.', E_USER_ERROR);
    }

}