<?php
require_once 'excel/SimpleXLSX.php';
ini_set('memory_limit', '512M');
set_time_limit(30000);


class SimpleImage
{

    var $image;
    var $image_type;

    function load($filename)
    {

        $image_info = getimagesize($filename);
        $this->image_type = $image_info[2];
        if ($this->image_type == IMAGETYPE_JPEG) {

            $this->image = imagecreatefromjpeg($filename);
        } elseif ($this->image_type == IMAGETYPE_GIF) {

            $this->image = imagecreatefromgif($filename);
        } elseif ($this->image_type == IMAGETYPE_PNG) {

            $this->image = imagecreatefrompng($filename);
        }
    }

    function save($filename, $image_type = IMAGETYPE_JPEG, $compression = 75, $permissions = null)
    {

        if ($image_type == IMAGETYPE_JPEG) {
            imagejpeg($this->image, $filename, $compression);
        } elseif ($image_type == IMAGETYPE_GIF) {

            imagegif($this->image, $filename);
        } elseif ($image_type == IMAGETYPE_PNG) {

            imagepng($this->image, $filename);
        }
        if ($permissions != null) {

            chmod($filename, $permissions);
        }
    }

    function output($image_type = IMAGETYPE_JPEG)
    {

        if ($image_type == IMAGETYPE_JPEG) {
            imagejpeg($this->image);
        } elseif ($image_type == IMAGETYPE_GIF) {

            imagegif($this->image);
        } elseif ($image_type == IMAGETYPE_PNG) {

            imagepng($this->image);
        }
    }

    function getWidth()
    {

        return imagesx($this->image);
    }

    function getHeight()
    {

        return imagesy($this->image);
    }

    function resizeToHeight($height)
    {

        $ratio = $height / $this->getHeight();
        $width = $this->getWidth() * $ratio;
        $this->resize($width, $height);
    }

    function resizeToWidth($width)
    {
        $ratio = $width / $this->getWidth();
        $height = $this->getheight() * $ratio;
        $this->resize($width, $height);
    }

    function scale($scale)
    {
        $width = $this->getWidth() * $scale / 100;
        $height = $this->getheight() * $scale / 100;
        $this->resize($width, $height);
    }

    function resize($width, $height)
    {
        $new_image = imagecreatetruecolor($width, $height);
        imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
        $this->image = $new_image;
    }

}
if (!empty($_POST))
{
    $extension = end(explode(".", $_FILES["dosya"]["name"])); 
    $allowed_extension = array("xls", "xlsx", "csv"); //Geçerli dosya tipleri
    if(in_array($extension, $allowed_extension)) 
    {
		
		
	 
    if($_POST['aktar']=='1'){

  


if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$urunadi = $elt['Ürün Adı'];	
	$bak = $DB->query("SELECT * FROM urunler WHERE urunAdi = '$urunadi' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


    $resimkonum = $elt['Ürün Resmi'];
    $resimad = basename($resimkonum);
    $uzanti = substr($resimad, -5, 5);
    $yeniad = md5(time($resimad)) .sifre_uret(15).$uzanti;
    $yol = "../images/urunler";
	
	$image = file_get_contents($resimkonum);
	file_put_contents($yol . '/' . $yeniad, $image);
	$image = new SimpleImage();
	$image->load("../images/urunler/" . $yeniad);
    $image->resize(420, 420);
    $image->save('../images/urunler/thumb-' . $yeniad);


	$urunidx = $elt['Ürün ID'];
	$urunadi = $elt['Ürün Adı'];
	$urunkodu = $elt['Ürün Kodu'];
	$seo = seo($elt['Ürün Adı'].'-'.$elt['Ürün Kodu']);
	$stok = $elt['Stok Sayısı'];
	$urunfiyati = $elt['Ürün Fiyatı'];
	$ifiyat = $elt['İndirimli Fiyatı'];
	$aciklama = $elt['Ürün Açıklaması'];
	$kategori = $elt['Ana Kategorisi'];
	$akategori = $elt['Alt Kategorisi'];
	$enakategori = $elt['EnAlt Kategorisi'];
	$ozellik = $elt['Özellik Adı'];
	$durum = $elt['Ürün Durumu'];
	$yildiz = "5";
	$tarih = date("d-m-Y H:i:s");
	$hit = "1";

    $veriekle = $DB->prepare("UPDATE urunler SET urunid=?, urunAdi=?,  urunkodu=?, resim=?, seo=?, stok=?, urunFiyati=?, ifiyat=?, metin=?, kategori=?, altkategori=?, baltkategori=?, ekad=?, durum=?, yildiz=?, tarih=?, hit=? WHERE urunAdi=?");
	$veriekle->execute(array($urunidx, $urunadi,  $urunkodu, $yeniad, $seo, $stok, $urunfiyati, $ifiyat, $aciklama, $kategori, $akategori, $enakategori, $ozellik, $durum, $yildiz, $tarih, $hit,$urunadi));
	
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürünler içe aktarıldı.
		</div>' ;	
	
	}
		
		
	} else {	
	
	$resimkonum = $elt['Ürün Resmi'];
    $resimad = basename($resimkonum);
    $uzanti = substr($resimad, -5, 5);
    $yeniad = md5(time($resimad)) .sifre_uret(15).$uzanti;
    $yol = "../images/urunler";
	
	$image = file_get_contents($resimkonum);
	file_put_contents($yol . '/' . $yeniad, $image);
	$image = new SimpleImage();
	$image->load("../images/urunler/" . $yeniad);
    $image->resize(420, 420);
    $image->save('../images/urunler/thumb-' . $yeniad);



	$urunidx = $elt['Ürün ID'];
	$urunadi = $elt['Ürün Adı'];
	$urunkodu = $elt['Ürün Kodu'];
	$seo = seo($elt['Ürün Adı'].'-'.$elt['Ürün Kodu']);
	$stok = $elt['Stok Sayısı'];
	$urunfiyati = $elt['Ürün Fiyatı'];
	$ifiyat = $elt['İndirimli Fiyatı'];
	$aciklama = $elt['Ürün Açıklaması'];
	$kategori = $elt['Ana Kategorisi'];
	$akategori = $elt['Alt Kategorisi'];
	$enakategori = $elt['EnAlt Kategorisi'];
	$ozellik = $elt['Özellik Adı'];
	$durum = $elt['Ürün Durumu'];
	$yildiz = "5";
	$tarih = date("d-m-Y H:i:s");
	$hit = "1";


    $veriekle = $DB->prepare("INSERT INTO urunler SET urunid=?, urunAdi=?,  urunkodu=?, resim=?, seo=?, stok=?, urunFiyati=?, ifiyat=?, metin=?, kategori=?, altkategori=?, baltkategori=?, ekad=?, durum=?, yildiz=?, tarih=?, hit=?");
	$veriekle->execute(array($urunidx, $urunadi,  $urunkodu, $yeniad, $seo, $stok, $urunfiyati, $ifiyat, $aciklama, $kategori, $akategori, $enakategori, $ozellik, $durum, $yildiz, $tarih, $hit));

	
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürünler içe aktarıldı.
		</div>' ;
   	

	} 

	}
	

	

	
	
		
		 } 
		 
	
      } 

$i++;
	
}
    












	
	} elseif ($_POST['aktar']=='2') {










if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$resimidx = $elt['Resim ID'];	
	$bak = $DB->query("SELECT * FROM sayfa_resim WHERE id = '$resimidx' and konu='urunler' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


    $resimkonumx = $elt['Ürün Resmi'];
    $resimadx = basename($resimkonumx);
    $uzantix = substr($resimadx, -5, 5);
    $yeniadx = md5(time($resimadx)) .sifre_uret(15).$uzantix;
    $yolx = "../images/diger";
	
	$imagex = file_get_contents($resimkonumx);
	file_put_contents($yolx . '/' . $yeniadx, $imagex);
	
	
	$resimidx = $elt['Resim ID'];
	$urunidx = $elt['Ürün ID'];
	$konu = "urunler";
    $veriekle = $DB->prepare("UPDATE  sayfa_resim SET resim_id=?, sayfaresim=?,  konu=? WHERE id=?");
	$veriekle->execute(array($urunidx, $yeniadx,  $konu, $resimidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürün Resimleri içe aktarıldı.
		</div>' ;
   	

	} 
		
		
	} else {	
	
	$resimkonumx = $elt['Ürün Resmi'];
    $resimadx = basename($resimkonumx);
    $uzantix = substr($resimadx, -5, 5);
    $yeniadx = md5(time($resimadx)) .sifre_uret(15).$uzantix;
    $yolx = "../images/diger";
	
	$imagex = file_get_contents($resimkonumx);
	file_put_contents($yolx . '/' . $yeniadx, $imagex);


    $resimidx = $elt['Resim ID'];
	$urunidx = $elt['Ürün ID'];
	$konu = "urunler";
    $veriekle = $DB->prepare("INSERT INTO sayfa_resim SET resim_id=?, sayfaresim=?,  konu=?,  id=?");
	$veriekle->execute(array($urunidx, $yeniadx,  $konu,  $resimidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürün Resimleri içe aktarıldı.
		</div>' ;
   	

	} 
	
	}
	

	

	
	
		
		 } 
		 
	
      } 

 $i++;
	
}
    















    } elseif ($_POST['aktar']=='3') {

    
if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$urunidx = $elt['Kategori ID'];	
	$bak = $DB->query("SELECT * FROM urunk WHERE id = '$urunidx' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


    $aresimkonumx = $elt['Kategori Resmi'];
    $aresimadx = basename($aresimkonumx);
    $auzantix = substr($aresimadx, -5, 5);
    $ayeniadx = md5(time($aresimadx)) .sifre_uret(15).$auzantix;
    $ayolx = "../images/urunk";
	
	$aimagex = file_get_contents($aresimkonumx);
	file_put_contents($ayolx . '/' . $ayeniadx, $aimagex);
	$image = new SimpleImage();
	$image->load("../images/urunk/" . $ayeniadx);
    $image->resize(870, 255);
    $image->save('../images/urunk/thumb-' . $ayeniadx);
	
	$urunidx = $elt['Kategori ID'];
    $baslik = $elt['Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ikon = $elt['Kategori İkonu'];
	$durum = "1";
    $veriekle = $DB->prepare("UPDATE  urunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=? WHERE id=?");
	$veriekle->execute(array($baslik, $seo,  $ayeniadx, $ikon, $durum, $urunidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Kategoriler içe aktarıldı.
		</div>' ;
   	

	} 
		
		
	} else {	
	
	$aresimkonumx = $elt['Kategori Resmi'];
    $aresimadx = basename($aresimkonumx);
    $auzantix = substr($aresimadx, -5, 5);
    $ayeniadx = md5(time($aresimadx)) .sifre_uret(15).$auzantix;
    $ayolx = "../images/urunk";
	
	$aimagex = file_get_contents($aresimkonumx);
	file_put_contents($ayolx . '/' . $ayeniadx, $aimagex);
	$image = new SimpleImage();
	$image->load("../images/urunk/" . $ayeniadx);
    $image->resize(870, 255);
    $image->save('../images/urunk/thumb-' . $ayeniadx);

    $urunidx = $elt['Kategori ID'];
    $baslik = $elt['Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ikon = $elt['Kategori İkonu'];
	$durum = "1";
    $veriekle = $DB->prepare("INSERT INTO  urunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=?, id=?");
	$veriekle->execute(array($baslik, $seo,  $ayeniadx, $ikon, $durum, $urunidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Kategoriler içe aktarıldı.
		</div>' ;
   	

	}
	
	
	}
	

	

	
	
		
		 } 
		 
	
      } 

 $i++;
	
}

    } elseif ($_POST['aktar']=='4') {
		
		





if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$urunidx = $elt['Alt Kategori ID'];	
	$bak = $DB->query("SELECT * FROM aurunk WHERE id = '$urunidx' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


    $kresimkonumx = $elt['Kategori Resmi'];
    $kresimadx = basename($kresimkonumx);
    $kuzantix = substr($kresimadx, -5, 5);
    $kyeniadx = md5(time($kresimadx)) .sifre_uret(15).$kuzantix;
    $kyolx = "../images/aurunk";
	
	$kimagex = file_get_contents($kresimkonumx);
	file_put_contents($kyolx . '/' . $kyeniadx, $kimagex);
	
	$urunidx = $elt['Alt Kategori ID'];
    $baslik = $elt['Alt Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ustkat = $elt['Üst Kategori ID'];
	$durum = "1";
    $veriekle = $DB->prepare("UPDATE  aurunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=? WHERE id=?");
	$veriekle->execute(array($baslik, $seo,  $kyeniadx, $ustkat, $durum, $urunidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Alt Kategoriler içe aktarıldı.
		</div>' ;
   	

	} 
		
		
	} else {	
	

	$kresimkonumx = $elt['Kategori Resmi'];
    $kresimadx = basename($kresimkonumx);
    $kuzantix = substr($kresimadx, -5, 5);
    $kyeniadx = md5(time($kresimadx)) .sifre_uret(15).$kuzantix;
    $kyolx = "../images/aurunk";
	
	$kimagex = file_get_contents($kresimkonumx);
	file_put_contents($kyolx . '/' . $kyeniadx, $kimagex);
	
	$urunidx = $elt['Alt Kategori ID'];
    $baslik = $elt['Alt Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ustkat = $elt['Üst Kategori ID'];
	$durum = "1";
    $veriekle = $DB->prepare("INSERT INTO aurunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=?, id=?");
	$veriekle->execute(array($baslik, $seo,  $kyeniadx, $ustkat, $durum, $urunidx));
	
	
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Alt Kategoriler içe aktarıldı.
		</div>' ;
   	

	}
	
	
	}
	

	

	
	
		
		 } 
		 
	
      } 

 $i++;
	
}



		

		
	} elseif ($_POST['aktar']=='5') {
		
		
   



if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$urunidx = $elt['EnAlt Kategori ID'];	
	$bak = $DB->query("SELECT * FROM baurunk WHERE id = '$urunidx' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


    $kresimkonumx = $elt['Kategori Resmi'];
    $kresimadx = basename($kresimkonumx);
    $kuzantix = substr($kresimadx, -5, 5);
    $kyeniadx = md5(time($kresimadx)) .sifre_uret(15).$kuzantix;
    $kyolx = "../images/baurunk";
	
	$kimagex = file_get_contents($kresimkonumx);
	file_put_contents($kyolx . '/' . $kyeniadx, $kimagex);
	
	$urunidx = $elt['EnAlt Kategori ID'];
    $baslik = $elt['EnAlt Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ustkat = $elt['Üst Kategori ID'];
	$durum = "1";
    $veriekle = $DB->prepare("UPDATE  baurunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=? WHERE id=?");
	$veriekle->execute(array($baslik, $seo,  $kyeniadx, $ustkat, $durum, $urunidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla EnAlt Kategoriler içe aktarıldı.
		</div>' ;
   	

	} 
		
		
	} else {	
	

	$kresimkonumx = $elt['Kategori Resmi'];
    $kresimadx = basename($kresimkonumx);
    $kuzantix = substr($kresimadx, -5, 5);
    $kyeniadx = md5(time($kresimadx)) .sifre_uret(15).$kuzantix;
    $kyolx = "../images/baurunk";
	
	$kimagex = file_get_contents($kresimkonumx);
	file_put_contents($kyolx . '/' . $kyeniadx, $kimagex);
	
	$urunidx = $elt['EnAlt Kategori ID'];
    $baslik = $elt['EnAlt Kategori Adı'];
	$seo = seo($elt['Seo Linki']);
	$ustkat = $elt['Üst Kategori ID'];
	$durum = "1";
    $veriekle = $DB->prepare("INSERT INTO baurunk SET baslik=?, seo=?,  resim=?,  ititle=?,  durum=?, id=?");
	$veriekle->execute(array($baslik, $seo,  $kyeniadx, $ustkat, $durum, $urunidx));
	
	
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla EnAlt Kategoriler içe aktarıldı.
		</div>' ;
   	

	}
	
	
	}
	

	

	
	
		
		 } 
		 
	
      } 

 $i++;
	
}


   
   
   
   
   
   
		
		
		} elseif ($_POST['aktar']=='6') {











if ( $xlsx = new SimpleXLSX( $_FILES['dosya']['tmp_name'] )); {

	// Produce array keys from the array values of 1st array element
	$header_values = $rows = [];

	foreach ( $xlsx->rows() as $k => $r ) {
		if ( $k === 0 ) {
			$header_values = $r;
			continue;
		}
		$rows[] = array_combine( $header_values, $r );
	}
    $i = 0;
	foreach ($rows as $elt) {
	if ($i < 1) {
		
	$resimidx = $elt['Özellik ID'];	
	$bak = $DB->query("SELECT * FROM urun_ozellik WHERE id = '$resimidx' LIMIT 1")->fetchAll(PDO::FETCH_ASSOC);

	if (count($bak) > 0) {


	$resimidx = $elt['Özellik ID'];
	$urunidx = $elt['Ürün ID'];
	$ozad = $elt['Özellik Adı'];
	$ozstok = $elt['Özellik Stok'];
    $veriekle = $DB->prepare("UPDATE  urun_ozellik SET resim_id=?, resim=?, ustok=? WHERE id=?");
	$veriekle->execute(array($urunidx, $ozad,  $ozstok, $resimidx));
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürün Özellikleri içe aktarıldı.
		</div>' ;
   	

	} 
		
		
	} else {	
	
	


	$resimidx = $elt['Özellik ID'];
	$urunidx = $elt['Ürün ID'];
	$ozad = $elt['Özellik Adı'];
	$ozstok = $elt['Özellik Stok'];
    $veriekle = $DB->prepare("INSERT INTO urun_ozellik SET resim_id=?, resim=?, ustok=?");
	$veriekle->execute(array($urunidx, $ozad, $ozstok));
	
	
	if ($veriekle) {
	$not = '<div class="alert alert-success">
		<button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
		<strong>Tebrikler!</strong> Başarıyla Ürün Özellikleri içe aktarıldı.
		</div>' ;
   	

	} 
	
	}
	

	

	
	
		
		 } 
		 
	
      } 

 $i++;
	
}
    













}

	
	
     
 

	}else{
 
  $not = '  <div class="alert alert-danger">
					                    <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
					                    <strong>Lütfen !</strong> xlsx veya xls uzantılı bir Excel dosyası yükleyiniz ....
					                </div>' ; 
 
 }
 
 
 
 
} 



 ?>

 <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Excel İçe Aktar
      </h1>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.html"><i class="fa fa-home"></i> Anasayfa</a></li>
       <li class="breadcrumb-item"><a href="excelver.html"> Excel</a></li>
        <li class="breadcrumb-item active">İçe Aktar</li>
      </ol>
	  <?=$not?>
    </section>

    <!-- Main content -->
    <section class="content">
	
      <div class="row">
        <div class="col-12">
         
   <div class="box box-default">
           
            <!-- /.box-header -->
            <div class="box-body">
            
			      <form class="form-horizontal" action="#" method="post" enctype="multipart/form-data">
				<!-- Tab panes -->
				<div class="tab-content">
					<div class="tab-pane active show" id="home1" role="tabpanel">
				
					    </br>
						  <div class="form-group">
					      <h5>Excel Dosyası</h5>
					      <div class="controls">
                          <div class="fileupload fileupload-new" data-provides="fileupload">
                          <div class="fileupload-new thumbnail" style="width: 200px; height: 150px;">
                          <?php if($_GET['ok']=="gn"){?>
                          <img src="../images/markalar/<?php echo $verial['resim']; ?>" style="width: 200px; height: 200px;" alt="" />
                          <?php } else { ?>
                          <img src="excel/excelyok.png" alt="" />
                          <?php }?>
                          </div>
                          <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 20px;"></div>
                          <div>
                          <span class="btn btn-default btn-file">
                          <span class="fileupload-new"><i class="fa fa-paper-clip"></i> Resim Seç</span>
                          <span class="fileupload-exists"><i class="fa fa-undo"></i> Değiştir</span>
                          <input name="dosya" type="file" class="default" />
                          </span>
                          <a href="#" class="btn btn-danger fileupload-exists" data-dismiss="fileupload"><i class="fa fa-trash"></i> Sil</a>
                          </div>
                          </div>   
						  
						
			<div class="form-group">
             <h5>İçe Aktarılacak Kısım</h5>
             <div class="controls">
                 <select class="form-control" name="aktar">
                 <option class="form-control" value="0">Seçiniz</option>
                 <option class="form-control"  <?php echo $_POST['aktar'] == '1' ? 'selected' : null; ?> value="1">Ürünler</option>
                 <option class="form-control"  <?php echo $_POST['aktar'] == '6' ? 'selected' : null; ?>  value="6">Ürün Özellikleri</option>
				 <option class="form-control"  <?php echo $_POST['aktar'] == '2' ? 'selected' : null; ?>  value="2">Ürün Diğer Resimleri</option>
				 <option class="form-control"  <?php echo $_POST['aktar'] == '3' ? 'selected' : null; ?>  value="3">Ana Kategoriler</option>
				 <option class="form-control"  <?php echo $_POST['aktar'] == '4' ? 'selected' : null; ?>  value="4">Alt Kategoriler</option>
				 <option class="form-control"  <?php echo $_POST['aktar'] == '5' ? 'selected' : null; ?>  value="5">EnAlt Kategoriler</option>
				 

              </select>
          </div>
      </div>
      
						  
						 
													
														   
														   
														   
														   
														   
														   
														   
														   
					        </div>
					        </div>
					                          				
						
						
						
						
						
						
						
						
						
						
					</div>
					
					
					
					
					
		
					
					
					
					          
						                    <button type="submit" name="exceldis" id="button3" class="btn btn-block  btn-warning">Dışa Aktar</button>						
                                    
					
					
					
					
					
					
					
				</div>
				</form>
            </div>
            <!-- /.box-body -->
          </div>
         

			
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
 <!-- include summernote css/js-->

 
 
 
 