<?php

class N11 {
    protected static $_appKey, $_appSecret, $_parameters, $_sclient;
    public $_debug = false;

    public function __construct(array $attributes = array()) {
        self::$_appKey = $attributes['appKey'];
        self::$_appSecret = $attributes['appSecret'];
        self::$_parameters = ['auth' => ['appKey' => self::$_appKey, 'appSecret' => self::$_appSecret]];
    }

    public function setUrl($url) {
		try {
			self::$_sclient = new \SoapClient($url, array("trace" => 1, "exception" => false, 'cache_wsdl' => WSDL_CACHE_NONE));
			return true; 
		} catch (\Exception $e) {
			return $e->getMessage();
		}
    }

    public function GetTopLevelCategories() {
        $this->setUrl('https://api.n11.com/ws/CategoryService.wsdl');
        return self::$_sclient->GetTopLevelCategories(self::$_parameters);
    }
	
	public function GetSubCategories( $catID ) {
        $this->setUrl('https://api.n11.com/ws/CategoryService.wsdl');
		self::$_parameters['categoryId'] = $catID;
		return self::$_sclient->GetSubCategories(self::$_parameters);
    }
	
	public function GetCategoryAttributes($catID) {
        $this->setUrl('https://api.n11.com/ws/CategoryService.wsdl');
		self::$_parameters['categoryId'] = $catID;
		self::$_parameters['pagingData'] = 0;
		self::$_parameters['totalCount'] = 1000;
		self::$_parameters['currentPage'] = 0;
        return self::$_sclient->GetCategoryAttributes(self::$_parameters);
    }
	
	public function GetCategoryAttributesId($catID) {
        $this->setUrl('https://api.n11.com/ws/CategoryService.wsdl');
		self::$_parameters['categoryId'] = $catID;
        return self::$_sclient->GetCategoryAttributesId(self::$_parameters);
    }

    public function GetCities() {
        $this->setUrl('https://api.n11.com/ws/CityService.wsdl');
        return self::$_sclient->GetCities(self::$_parameters);
    }

    public function GetProductList($totalCount, $pageSize, $currentPage) {
        $this->setUrl('https://api.n11.com/ws/ProductService.wsdl');
        self::$_parameters['pagingData'] = ['totalCount' => $totalCount, 'pageSize' => $pageSize, 'currentPage' => $currentPage];
        $return = self::$_sclient->GetProductList(self::$_parameters);
		return $return->products->product;
		// return $return;
    }

    public function GetProductBySellerCode($sellerCode) {
        $this->setUrl('https://api.n11.com/ws/ProductService.wsdl');
        self::$_parameters['sellerCode'] = $sellerCode;
        return self::$_sclient->GetProductBySellerCode(self::$_parameters);
    }

    public function SaveProduct(array $product = Array()) {
        $this->setUrl('https://api.n11.com/ws/ProductService.wsdl');
        self::$_parameters['product'] = $product;
        $array  = self::$_sclient->SaveProduct(self::$_parameters);
		$result = 0;
		if ( !empty($array->result->status) and $array->result->status == 'success' ) {
			$result = 1;
		}
		return $result;
    }

    public function DeleteProductBySellerCode($sellerCode) {
        $this->setUrl('https://api.n11.com/ws/ProductService.wsdl');
        self::$_parameters['productSellerCode'] = $sellerCode;
        return self::$_sclient->DeleteProductBySellerCode(self::$_parameters);
    }

    public function DetailedOrderList(array $searchData = Array()) {
        $this->setUrl('https://api.n11.com/ws/OrderService.wsdl');
        self::$_parameters['searchData'] = $searchData;
        $array  = self::$_sclient->DetailedOrderList(self::$_parameters);
		$result = array();
		if ( !empty($array->result->status) and $array->result->status == 'success' ) {
			if ( !empty($array->orderList->order) ) {
				if ( is_array($array->orderList->order) ) {
					if ( count($array->orderList->order) != 0 ) {
						foreach ( $array->orderList->order as $value ) {
							$result[] = $value;
						}
					}
				}
			}
		}
		return $result;
    }
	
	public function orderDetail($id) {
		$this->setUrl('https://api.n11.com/ws/OrderService.wsdl');
		self::$_parameters['orderRequest'] = array('id' => $id);
		return self::$_sclient->orderDetail(self::$_parameters);
	}
	
	public function GetShipmentTemplate($name) {
		$this->setUrl('https://api.n11.com/ws/ShipmentCompanyService.wsdl');
		self::$_parameters['name'] = $name;
		return self::$_sclient->GetShipmentTemplate(self::$_parameters);
	}
	
	public function GetShipmentTemplateList() {
		$this->setUrl('https://api.n11.com/ws/OrderService.wsdl');
		return self::$_sclient->GetShipmentTemplateList();
	}

    public function GetN11Kategori( $array, $val ) {
		$result = 0;
		if ( !empty($array->result->status) and $array->result->status == 'success' ) {
			if ( is_array($array->categoryList->category) ) {
				if ( count($array->categoryList->category) != 0 ) {
					foreach ( $array->categoryList->category as $value ) {
						if ( strpos($value->name,$val) !== false ) {
							$result = $value->id;
						}
					}
				}
			}
		}
		if ( $result == 0 ) {
			$newArr = array();
			foreach ($array->categoryList->category as $value) {
				$newArr[] = $value->id;
			}
			$result = $newArr[array_rand($newArr)];
		}
		return $result;
	}

    public function GetN11Varyant( $array ) {
		$result = array();
		if ( !empty($array->result->status) and $array->result->status == 'success' ) {
			if ( !empty($array->category->attributeList->attribute) ) {
				if ( is_array($array->category->attributeList->attribute) ) {
					if ( count($array->category->attributeList->attribute) != 0 ) {
						foreach ( $array->category->attributeList->attribute as $value ) {
							if ( !empty($value->mandatory) ) {
								if ( $value->mandatory == 1 ) {
									$i = 0;
									foreach ( $value->valueList as $val ) {
										if ( $i < 20 ) {
											$result[] = "'attribute' => array(
													'name'  => ". $value->name .",
													'value' => ". $val[$i]->id .",
												),";
											$i++;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		if ( $result == 0 ) {
			$result = array(
				'attribute' => array()
			);
		}
		return $result;
	}

    public function __destruct() {
        if ( $this->_debug ) {
            print_r(self::$_parameters);
        }
    }
}